function [] = PlotMeshWeight(NODE,ELEM,weightNODE)

Ne = length(ELEM);
Nn = size(NODE,1);
NpE = cellfun(@numel,ELEM);

N3 = sum(NpE==3);
NP = sum(NpE>3);
if (N3+NP~=Ne)
    error('There is an element with 2 or fewer vertices.')
end
Ntria = N3 + sum(NpE(NpE>3));
TRIA = nan(Ntria,3);

Nt = 0;
Nc = 0;
CM = nan(NP,2);
CMweight = nan(NP,1);
for i=1:Ne
    if NpE(i)==3 % If the element is a triangle, just plot it
        Nt = Nt + 1;
        TRIA(Nt,:) = ELEM{i};
    else % If element is quad or higher, triangulate to center
        Nc = Nc + 1;
        CM(Nc,:) = mean(NODE(ELEM{i}(:),:),1);
        CMweight(Nc) = mean(weightNODE(ELEM{i}(:)));
        v2 = ELEM{i}(end);
        for j=1:NpE(i)
            v1 = v2;
            v2 = ELEM{i}(j);
            Nt = Nt + 1;
            TRIA(Nt,:) = [v1 v2 Nn+Nc];
        end
    end
end

weightNODE = [weightNODE; CMweight];

figure('Color','w'), hold on, axis equal, axis off
patch('Faces',TRIA,'Vertices',[NODE; CM],'FaceVertexCData',weightNODE,'FaceColor','interp','EdgeColor','none')

MaxNVer = max(NpE);         % Max vertices/element in mesh
PadWNaN = @(E) [E(:)' NaN(1,MaxNVer-numel(E))];  % Pad cells with NaN
ElemMat = cellfun(PadWNaN,ELEM,'UniformOutput',false);
ElemMat = vertcat(ElemMat{:});               % Create padded element matrix
patch('Faces',ElemMat,'Vertices',NODE,'FaceColor','none');

plot(NODE(:,1),NODE(:,2),'k.')

colormap(parula)
set(gca,'CLim',[0 max(weightNODE)]), colorbar
title('Nodal Weights')

axis('tight'), drawnow
return