function [NODE,ELEM,SUPP,LOAD,HYDH,EMAT] = DuncanWrightDomain(RefineLvl)

if (nargin<1)
    RefineLvl = 2; 
end

% Nodes
NODE = [ 0  127; 
        294 127;
        947 127; 
        1241 127;
        595 323; 
        645 323;
        580 338;
        660 338];

% Elements
ELEM = cell(1,4);

ELEM{1} = [1 2 5 7];
ELEM{2} = [5 6 8 7];
ELEM{3} = [3 4 8 6];
ELEM{4} = [2 3 6 5];

EMAT = [ones(3,1); 2];

% Refinement
[NODE,ELEM,EMAT] = MeshRefine(NODE,ELEM,EMAT,RefineLvl);

% Tolerance
Nn = size(NODE,1);
dx = max(NODE) - min(NODE);
tol = 1e-8 * sqrt(dx(1)*dx(2)) / Nn;

% Supports
SUPP = find(abs(NODE(:,1)-min(NODE(:,1)))<tol | ...
            abs(NODE(:,1)-max(NODE(:,1)))<tol | ...
            abs(NODE(:,2)-min(NODE(:,2)))<tol );
% LOADS
LOAD = [];

% Hydraulic heads
hNODE = find(abs(NODE(:,2)-127-(211/580)*NODE(:,1) )<tol & NODE(:,2) <= 315 );
hNODE2 = find(abs(NODE(:,1)-1241 )<tol );
HYDH = [hNODE repmat([315.],length(hNODE),1); hNODE2 127];

return