function [BARS] = GenerateGS(NODE,ELEM,Lvl,RestrictDomain,ColTol)
narginchk(3,5)

if nargin<5, ColTol=0.99999; end
if (nargin<4 || isempty(RestrictDomain)), RestrictDomain=@(~,~)[]; end

% Get element connectivity matrix with the specified level
Nn = max(cellfun(@max,ELEM)); Ne = length(ELEM);
A0 = sparse(Nn,Nn);
for i=1:Ne, A0(ELEM{i},ELEM{i}) = true; end
A0 = A0 - speye(Nn,Nn);
A = logical(A0^Lvl);   % Logical makes values >0 equal to 1
A = A - speye(Nn,Nn); % Remove diagonal; works because logic makes it =1

% Check for collisions
[I,J] = find(triu(A));
Nb = [length(J) NaN NaN]; % Num. of bars: initial - (collision + collinear)
RemoveFlag = RestrictDomain(NODE,[I J]); % Find bars in colision zones
I(RemoveFlag) = []; J(RemoveFlag) = [];
A = sparse([I; J],[J; I],1,Nn,Nn); % Regenerate (symmetric) connecti matrix
Nb(2) = length(J);
fprintf('-- Bars removed by collision:    %.0f\n',Nb(1)-Nb(2))

for startnode=1:Nn
    endnode = find(A(:,startnode));
    if isempty(endnode)
        fprintf('-INFO- Node %.0f has no bars (potentially unstable).\n',startnode)
    else
        D = NODE(endnode,:) - repmat(NODE(startnode,:),length(endnode),1);
        L = sqrt(D(:,1).^2 + D(:,2).^2);  % Length of bars
        D = [D(:,1)./L D(:,2)./L];        % Normalized dir
        cosD = D * D'; % Matrix with all-to-all members' angle cosines
        
        [~,list] = sort(L); % Sort bars by length
        keep = nan(length(endnode),1);
        k = 1; % Number of bars accepted
        keep(k) = list(1);
        for j=2:length(list)
            if all(cosD(keep(1:k),list(j))<=ColTol)
                k = k + 1;
                keep(k) = list(j);
            end
        end
        A(:,startnode) = sparse(endnode(keep(1:k)),1,1,Nn,1);
    end
end
A = A + A' + A0; % Add level 1 to ground structure regardless of collisions
[I,J] = find(triu(A));
BARS = [I J];
Nb(3) = length(J);
fprintf('-- Bars removed by collinearity: %.0f\n',Nb(2)-Nb(3))
return