function [NODE,ELEM,SUPP,LOAD] = DonutDomain(Nt,Nr,Ri,Ro,ProblemID)
narginchk(4,5)

if (nargin==4 || isempty(ProblemID)), ProblemID = 1; end
switch lower(ProblemID)
    case {'flower',1}, Tf = 2*pi;
    case {'quarterannulus',2}, Tf = pi/2;
    otherwise, Tf = 2*pi;
end

% Mesh generation
[T,R] = meshgrid(linspace(0,Tf,Nt+1),linspace(Ri,Ro,Nr+1));
ELEM = cell(Nt*Nr,1);
k = 0;
for i=1:Nt
    for j=1:Nr
        k = k + 1;
        n1 = (i-1)*(Nr+1)+j; n3 = n1+(Nr+1);
        ELEM{k} = [n1 n1+1 n3+1 n3];
    end
end
if (Tf==2*pi)
  T(:,end) = []; R(:,end) = [];
  for j=1:Nr
      ELEM{(k-Nr)+j}(3:4) = [j+1 j];
  end
elseif (Tf>2*pi)
  error('Cannot generate donut-mesh for more than a full circle')
end
NODE = [R(:).*cos(T(:)) R(:).*sin(T(:))];

% Load and supports
Nn = size(NODE,1);
switch lower(ProblemID)
    case {'flower',1}
        Nl = 5; Pl = 1; % Number of load divisions & load magnitude
        SUPP = zeros(Nt,3);
        SUPP(:,1) = 1:(Nr+1):Nn;
        if (rem(Nt,Nl)~=0)
            fprintf('WARNING: Circle cannot be evenly divided for supplied Nt\n')
        end
        aux = round(linspace(1,Nt+1,Nl+1));
        aux(end) = [];
        LOAD = zeros(length(aux),3);
        LOAD(:,1) = aux*(Nr+1);
        V = NODE(LOAD(:,1),:);
        L = sqrt(V(:,1).^2 + V(:,2).^2);
        V = [V(:,1)./L V(:,2)./L];
        LOAD(:,2:3) = Pl * [-V(:,2) V(:,1)];
    case {'quarterannulus',2}
        SUPP = [ (1:Nr+1)'   nan(Nr+1,1)  zeros(Nr+1,1);
                (Nn-Nr:Nn)' zeros(Nr+1,1)  nan(Nr+1,1) ];
        LOAD = [Nr+1 -0.5  0 ;
                 Nn    0  0.5];
    otherwise
        SUPP = []; LOAD = [];
        fprintf('-INFO- Donut domain generated with no loads/BC\n')
end
return