function flag=rSurf(RNODE,RFACE,NODE,BARS)

flag = false(size(BARS,1),length(RFACE));
for i=1:length(RFACE)
    switch length(RFACE{i})
        case {1,2}
            error('Surface facets must have 3+ nodes.')
        case 3
            flag(:,i) = rTriangle(RNODE(RFACE{i}(1),:),RNODE(RFACE{i}(2),:),...
                        RNODE(RFACE{i}(3),:),NODE,BARS);
        case 4
            flag(:,i) = rQuad(RNODE(RFACE{i}(1),:),RNODE(RFACE{i}(2),:),...
                        RNODE(RFACE{i}(3),:),RNODE(RFACE{i}(4),:),NODE,BARS);
        otherwise
            aux = false(size(BARS,1),length(RFACE{i})-2);
            for j=3:length(RFACE{i})
                aux(:,j-2) = rTriangle(RNODE(RFACE{i}(1),:),RNODE(RFACE{i}(j-1),:),...
                                       RNODE(RFACE{i}(j),:),NODE,BARS);
            end
            flag(:,i) = any(aux,2);
    end
end
flag = any(flag,2);